import { View, StyleSheet } from "react-native";
import React from "react";
import SkeletonElement from "../../../../../../src/skeletons/SkeletonElement";
import dpr from "../../../../../Utilities/CustomStyleAttribute/dpr";

const ReviewSkeleton = () => {
    return (
        <View style={style.cont}>
            <SkeletonElement wrapperStyle={style.skeletonWrapperStyle1} />
            <View style={style.headerCont}>
                <View style={style.header}>
                    <View style={style.img}>
                        <SkeletonElement wrapperStyle={style.skeletonWrapperStyle2}/>
                    </View>
                    <SkeletonElement wrapperStyle={style.skeletonWrapperStyle3}/>
                </View>
                <SkeletonElement wrapperStyle={style.skeletonWrapperStyle4}/>
            </View>
            <SkeletonElement wrapperStyle={style.skeletonWrapperStyle5n6}/>
            <SkeletonElement wrapperStyle={style.skeletonWrapperStyle5n6}/>
        </View>
    );
};

export default ReviewSkeleton;

const style = StyleSheet.create({
    cont: {
        marginBottom: dpr(10),
    },
    headerCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
    },
    header: {
        flexDirection: "row",
        alignItems: "center",
    },
    img: {
        marginRight: dpr(10),
    },
    skeletonWrapperStyle1: {
        height: dpr(20),
        width: "100%",
    },
    skeletonWrapperStyle2: {
        height: dpr(70),
        width: dpr(70),
        borderRadius: 50,
    },
    skeletonWrapperStyle3: {
        height: dpr(30),
        width: dpr(120),
    },
    skeletonWrapperStyle4: {
        height: dpr(30),
        width: dpr(80),
    },
    skeletonWrapperStyle5n6: {
        height: dpr(15),
        width: "100%",
    },
});
